PrefabFiles = {
	"scrap",
	"engineer",
	"esentry",
	"dispenser",
	"eteleporter",
	"eteleporter_exit",
	"tf2wrench",
	"gibus",
	"ehardhat",
	"esentry_bullet",
	"esentry_rocket",
}

Assets = {

    Asset( "IMAGE", "images/saveslot_portraits/engineer.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/engineer.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/engineer.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/engineer.xml" ),

    Asset( "IMAGE", "bigportraits/engineer.tex" ),
    Asset( "ATLAS", "bigportraits/engineer.xml" ),

    Asset( "IMAGE", "images/minimap/engineer.tex" ),
    Asset( "ATLAS", "images/minimap/engineer.xml" ),

    Asset("ATLAS", "images/hud/engietab.xml" ),
    Asset("IMAGE", "images/hud/engietab.tex"),
	
	Asset("ATLAS", "images/inventoryimages/esentry.xml"),
    Asset("IMAGE", "images/inventoryimages/esentry.tex"),
    Asset("IMAGE", "images/minimap/esentry.tex"),
    Asset("ATLAS", "images/minimap/esentry.xml"),
	
    Asset("ATLAS", "images/inventoryimages/dispenser.xml"),
    Asset("IMAGE", "images/inventoryimages/dispenser.tex"),
    Asset("IMAGE", "images/minimap/dispenser.tex"),
    Asset("ATLAS", "images/minimap/dispenser.xml"),
	
    Asset("IMAGE", "images/minimap/eteleporter.tex"),
    Asset("ATLAS", "images/minimap/eteleporter.xml"),
    Asset("ATLAS", "images/inventoryimages/eteleporter.xml"),
    Asset("IMAGE", "images/inventoryimages/eteleporter.tex"),
}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local RECIPETABS = GLOBAL.RECIPETABS

GLOBAL.STRINGS.NAMES.ENGINEER = "Engineer"
GLOBAL.STRINGS.CHARACTER_TITLES.engineer = "The Amiable Texan"
GLOBAL.STRINGS.CHARACTER_NAMES.engineer = "Dell Conagher"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.engineer = "*Can build his various contraptions\n*Brings his own wrench and hard hat\n*Loves science"
GLOBAL.STRINGS.CHARACTER_QUOTES.engineer = "\"I solve practical problems.\""
GLOBAL.STRINGS.CHARACTERS.ENGINEER = require "speech_engineer"

TUNING.ENGIE_DMGDEBUFF = GetModConfigData("engiedmgdebuff")

TUNING.TF2WRENCH_DAMAGE = GetModConfigData("tf2wrenchdmg")
TUNING.TF2WRENCH_USES = GetModConfigData("tf2wrenchuses")
TUNING.ARMOR_HARDHAT_ABSORPTION = GetModConfigData("hardhatabsorb")
TUNING.ARMOR_EHARDHAT = GetModConfigData("ehardhatdura")

TUNING.DISP_RANGE = GetModConfigData("disprange")
TUNING.DISP_HEALING = GetModConfigData("dispenserhealingrate")

GLOBAL.SENTRY_RANGE = GetModConfigData("Sentry_Range")
GLOBAL.SENTRY_DAMAGE = GetModConfigData("Sentry_Damage")
GLOBAL.SENTRY_ROF = GetModConfigData("Sentry_ROF")
GLOBAL.SENTRY_HEALTH = GetModConfigData("Sentry_Health")

RECIPETABS.ENGIETAB = {str = "Construction", sort=12, icon = "engietab.tex", icon_atlas = "images/hud/engietab.xml"}

--Scrap
STRINGS.NAMES.SCRAP = "Scrap Metal"
STRINGS.RECIPE_DESC.SCRAP = "Scrapped Metal."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SCRAP = "Messy metallic fuel parts."

--Wrench
GLOBAL.STRINGS.NAMES.TF2WRENCH = "Wrench"
GLOBAL.STRINGS.RECIPE_DESC.TF2WRENCH = "Take it like a man, shorty"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TF2WRENCH = "It's a wrench, for fixing things."

--Hard Hat
GLOBAL.STRINGS.NAMES.EHARDHAT = "Hard Hat"
GLOBAL.STRINGS.RECIPE_DESC.EHARDHAT = "It's hard and it's a hat."
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.EHARDHAT = "Pretty hard hat, that."

--Gibus
GLOBAL.STRINGS.NAMES.GIBUS = "Ghostly Gibus"
GLOBAL.STRINGS.RECIPE_DESC.GIBUS = "Not the classiest hat of all."
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.GIBUS = "What a weird hat."

--Dispenser
GLOBAL.STRINGS.RECIPE_DESC.DISPENSER = "Erecting a Dispenser!"
GLOBAL.STRINGS.NAMES.DISPENSER = "Dispenser"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.DISPENSER = "Seems healthy enough."

--Teleporter
GLOBAL.STRINGS.RECIPE_DESC.ETELEPORTER = "Teleporter goin' up."
GLOBAL.STRINGS.NAMES.ETELEPORTER = "Teleporter Entrance"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ETELEPORTER = "Teleportation can be so useful."

--Teleporter Exit
GLOBAL.STRINGS.RECIPE_DESC.ETELEPORTER_EXIT = "Teleporter goin' up."
GLOBAL.STRINGS.NAMES.ETELEPORTER_EXIT = "Teleporter Exit"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ETELEPORTER_EXIT = "Teleportation can be so useful."

--Sentry
GLOBAL.STRINGS.RECIPE_DESC.ESENTRY = "Buildin' a sentry!"
GLOBAL.STRINGS.NAMES.ESENTRY = "Sentry Gun"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ESENTRY = "I hope it doesn't turn on me!"

-- Actions ------------------------------

local Action = GLOBAL.Action
local ActionHandler = GLOBAL.ActionHandler

local ENGIETELEPORT = Action()
ENGIETELEPORT.str = "Teleport"
ENGIETELEPORT.id = "ENGIETELEPORT"
ENGIETELEPORT.fn = function(act)
	if act.doer ~= nil and act.target ~= nil and act.doer:HasTag("player") and act.target.components.engieteleporter then
	    act.target.components.engieteleporter.boundEntrance = act.target
	    act.target.components.engieteleporter:TeleportAction(act.doer)
	end
	return true
end

AddAction(ENGIETELEPORT)

local ENGIEWORK = Action()
ENGIEWORK.str = "Repair"
ENGIEWORK.id = "ENGIEWORK"
ENGIEWORK.fn = function(act)
	if act.target ~= nil and act.target:HasTag("dispenser") or act.target:HasTag("esentry")  then
	    act.target.components.engieworkable:WorkedBy(act.doer, 0)
	end
	return true
end

AddAction(ENGIEWORK)

-- Stategraph ----------------------------

AddStategraphActionHandler("wilson", GLOBAL.ActionHandler(ENGIEWORK,
        function(inst)
            if inst:HasTag("beaver") then
                return not inst.sg:HasStateTag("gnawing") and "gnaw" or nil
            end
            return not inst.sg:HasStateTag("prehammer")
                and (inst.sg:HasStateTag("hammering") and
                    "hammer" or
                    "hammer_start")
                or nil
        end))

AddStategraphActionHandler("wilson", GLOBAL.ActionHandler(ENGIETELEPORT, "doshortaction")) --ENGIDESTINATION

AddMinimapAtlas("images/minimap/esentry.xml")
AddMinimapAtlas("images/minimap/eteleporter.xml")
AddMinimapAtlas("images/minimap/dispenser.xml")
AddMinimapAtlas("images/minimap/engineer.xml")
AddModCharacter("engineer", "MALE")